//OS version = ubuntu 16.04 LTS
//Scilab version 5.5.2

clear;
clc;

lambda=1;                      			// defining λ

d1=lambda/4;                  			//distance between the dipoles d1= λ/4

theta=0:0.01:2*%pi;		 	// Theta varies from 0 to 360

u1=(%pi*d1/lambda).*cos(theta);        		//u1 = πd1/λ*cosӨ

AF1=2.798.*cos(u1)+2.496.*cos(3.*u1)+1.974.*cos(5.*u1)+1.357.*cos(7.*u1)+cos(9.*u1);
				//expression for array factor pattern for N=10, 2M=10

p=get("hdl");                   		//get handle on current entity (here the polyline entity)

p.line_style=1;

polarplot(theta,AF1)		//plot polar plot

d2=lambda/2;                  			//distance between the dipoles d2= λ/2

u2=(%pi*d2/lambda).*cos(theta);        		//u2 = πd2/λ*cosӨ

AF2=2.798.*cos(u2)+2.496.*cos(3.*u2)+1.974.*cos(5.*u2)+1.357.*cos(7.*u2)+cos(9.*u2);
				//expression for array factor pattern for N=10, 2M=10

p.line_style=8;

title('POLAR PLOT OF ARRAY FACTOR PATTERN OF N ELEMENT DOLPH TSCHEBYSCHEFF ARRAY CASE: N=10 and d = λ /4 , λ /2');


polarplot(theta,AF2)		//plot polar plot

hl=legend('d = λ/4','d = λ/2');
